#include "game.h"

#include "models.h"
#include "bezierpaths.h"

//#define MULTIBOOT volatile const int __gba_multiboot;
//MULTIBOOT

signed short SIN[256];

int main()
{
	MakeSINTable();
	ClearLine32(160,0x6000000,0);

	//REG_WSCNT = ( 5 << 2 ) | ( 1 << 14 );
	//kragInit(KRAG_INIT_STEREO);
	InitIntr();
	SetVBlankIntr(dummy);
	REG_DISPCNT = 0x404|OBJ_ENABLE;

	int i;


	REG_BLDMOD = TOP_BG2|MODE_DARKEN;
	Fade(31);

	LZ77UnCompVRAM(&intro,(void*)0x6000000);
	CPUSet(&intro_pal,(void*)0x5000000,18);


	for(i=16<<2;i>0;i--) {
		Fade(i>>2);
		IntrVBlankWait();
	}
	for(i=0;i<60*2;i++) IntrVBlankWait();


	for(i=0;i<32;i++) BGPaletteMem[i] = RGB16(i,i,16+(i>>1));;
	BGPaletteMem[32] = 31<<5;

	//krapPlay(&mod_sand, KRAP_MODE_LOOP, 0);

	LZ77UnCompVRAM(&bulletsprites,(void*)0x6014000);
	CPUSet(&bulletsprites_pal,(void*)0x5000200,16);

	InitLevel();

	while(1)
	{
		SwitchBuffers();
		ClearLine32(160,(int)BackBuffer,0);

		PlayerUpdate();
		UpdateLevel();
		EnemiesUpdate();
		BulletsUpdate();
		ParticlesUpdate();
		IntrVBlankWait();
	}
	return 0;
}

